"use strict";
(() => {
  // src/injected.ts
  (function() {
    if (window.anonyma) return;
    const listeners = {};
    const pending = /* @__PURE__ */ new Map();
    let reqId = 0;
    function genId() {
      return `anm_${Date.now()}_${++reqId}`;
    }
    function send(type, payload) {
      return new Promise((resolve, reject) => {
        const id = genId();
        pending.set(id, { resolve, reject });
        window.postMessage({
          target: "anonyma-content",
          message: { type, id, payload }
        }, "*");
        setTimeout(() => {
          if (pending.has(id)) {
            pending.delete(id);
            reject(new Error("Request timed out"));
          }
        }, 12e4);
      });
    }
    window.addEventListener("message", (event) => {
      if (event.source !== window) return;
      if (!event.data || event.data.target !== "anonyma-injected") return;
      const { id, response } = event.data;
      const p = pending.get(id);
      if (!p) return;
      pending.delete(id);
      if (response?.success) {
        p.resolve(response.data);
      } else {
        p.reject(new Error(response?.error || "Unknown error"));
      }
    });
    const provider = {
      isAnonyma: true,
      async getState() {
        return send("ANONYMA_GET_STATE");
      },
      async connect() {
        const result = await send("ANONYMA_CONNECT");
        emit("connect", result);
        return result;
      },
      async disconnect() {
        await send("ANONYMA_DISCONNECT");
        emit("disconnect");
      },
      async getWallet() {
        return send("ANONYMA_GET_WALLET");
      },
      async signAndSendTransaction(params) {
        return send("ANONYMA_SIGN_TRANSACTION", params);
      },
      async signMessage(message) {
        return send("ANONYMA_SIGN_MESSAGE", { message });
      },
      async getBalance() {
        return send("ANONYMA_GET_BALANCE");
      },
      on(event, cb) {
        if (!listeners[event]) listeners[event] = [];
        listeners[event].push(cb);
      },
      off(event, cb) {
        if (!listeners[event]) return;
        listeners[event] = listeners[event].filter((fn) => fn !== cb);
      }
    };
    function emit(event, ...args) {
      (listeners[event] || []).forEach((fn) => {
        try {
          fn(...args);
        } catch {
        }
      });
    }
    window.anonyma = provider;
    window.dispatchEvent(new Event("anonyma#initialized"));
  })();
})();
