"use strict";
(() => {
  // src/content.ts
  var script = document.createElement("script");
  script.src = chrome.runtime.getURL("injected.js");
  script.type = "text/javascript";
  (document.head || document.documentElement).appendChild(script);
  script.onload = () => script.remove();
  window.addEventListener("message", (event) => {
    if (event.source !== window) return;
    if (!event.data || event.data.target !== "anonyma-content") return;
    const msg = event.data.message;
    msg.origin = window.location.origin;
    chrome.runtime.sendMessage(msg, (response) => {
      window.postMessage({
        target: "anonyma-injected",
        id: msg.id,
        response
      }, "*");
    });
  });
})();
